//: Enums
//:
//: Enums represent state and contain a list of scenarios.
//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:


enum DoorState {
    case locked
    case unlocked
}


//:
//: -------------------
//:
//: Instances
//:
//: -------------------
//:


let frontDoorStatus = DoorState.locked
switch frontDoorStatus {
case .locked:
    print("Front door is locked.")
case .unlocked:
    print("Front door is unlocked.")
}


//:
//: -------------------
//:
//: ## Raw Values
//:
//: The enum can reflect a raw value such as an `Int`.
//:
//: -------------------
//:


enum Month: Int {
    case january = 1
    case february = 2
    case march = 3
    case april = 4
    case may = 5
    case june = 6
    case july = 7
    case august = 8
    case september = 9
    case october = 10
    case november = 11
    case december = 12
}

let january = Month(rawValue: 1)
let december = Month(rawValue: 12)


//:
//: -------------------
//:
//: ## Auto-incrementing Raw Values
//:
//: -------------------
//:


enum Month2: Int {
    case january = 1
    case february
    case march
    case april
    case may
    case june
    case july
    case august
    case september
    case october
    case november
    case december
}

let january2 = Month2(rawValue: 1)
let december2 = Month2(rawValue: 12)


//: -------------------
//:
//: ## Associated Values
//:
//: A stored property for that individual case.
//:
//: -------------------
//:


enum ServerResponse {
    case result(String, String)
    case failure(String)
}

let success = ServerResponse.result("6:00 am", "8:09 pm")
let failure = ServerResponse.failure("Out of cheese.")

switch success {
    case let .result(sunrise, sunset):
        print("Sunrise is at \(sunrise) and sunset is at \(sunset).")
    case let .failure(message):
        print("Failure...  \(message)")
}


//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:
//: ## ![3 Days Of Swift Logo](3DaysIcon146.png) 3 Days Of Swift 
//:
//: © Copyright. All rights reserved.
//:
//: 🧕🏻🙋🏽‍♂️👨🏿‍💼👩🏼‍💼👩🏻‍💻💁🏼‍♀️👨🏼‍💼🙋🏻‍♂️🙋🏻‍♀️👩🏼‍💻🙋🏿💁🏽‍♂️🙋🏽‍♀️🙋🏿‍♀️🧕🏾🙋🏼‍♂️
//:
//: Welcome to our community of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) developers!
